/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images.command;

import com.andavin.images.Images;
import com.andavin.images.command.BaseCommand;
import com.andavin.images.image.CustomImage;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;

final class DeleteNearCommand
extends BaseCommand {
    DeleteNearCommand() {
        super("near", "images.command.delete.near");
        this.setAliases("n");
        this.setMinimumArgs(1);
        this.setUsage("/image delete near <range>");
        this.setDesc("Delete all images within a specified range");
    }

    @Override
    public void execute(Player player, String label, String[] args) {
        int range;
        try {
            range = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            player.sendMessage("\u00a7cInvalid range: \u00a7f" + args[0]);
            return;
        }
        if (range < 1) {
            player.sendMessage("\u00a7cRange must be at least 1");
            return;
        }
        Location location = player.getLocation();
        List<CustomImage> images = Images.getMatchingImages(image -> image.isInRange(location, range));
        if (images.isEmpty()) {
            player.sendMessage("\u00a7cNo images found in range of \u00a7f" + range);
            return;
        }
        int success = 0;
        for (CustomImage image2 : images) {
            if (!Images.removeImage(image2)) continue;
            image2.destroy();
            ++success;
        }
        if (success == images.size()) {
            player.sendMessage("\u00a7aSuccessfully deleted \u00a7f" + success + "\u00a7a images within \u00a7f" + range + " blocks");
        } else {
            player.sendMessage("\u00a7cFound \u00a7f" + images.size() + "\u00a7c nearby images");
            if (success > 0) {
                player.sendMessage("\u00a7cbut only \u00a7f" + success + "\u00a7c were successfully deleted");
            } else {
                player.sendMessage("\u00a7cbut there was an issue deleting them");
            }
        }
    }
}

